VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form SpectrumMain 
   Caption         =   "EPE Spectrum Analyser (ESA) V1.0"
   ClientHeight    =   6465
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   10080
   Icon            =   "SpectrumMain.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   6465
   ScaleWidth      =   10080
   StartUpPosition =   2  'CenterScreen
   Begin VB.DriveListBox Drive1 
      Height          =   315
      Left            =   9000
      TabIndex        =   71
      ToolTipText     =   "Selects drive to be treated as Hard Drive - see notes in Directory screen (via Disk Path green buttons)"
      Top             =   600
      Width           =   800
   End
   Begin VB.TextBox Text1 
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   0  'None
      Height          =   285
      Index           =   4
      Left            =   120
      Locked          =   -1  'True
      TabIndex        =   41
      Text            =   $"SpectrumMain.frx":0442
      ToolTipText     =   "There are five scale markings, each selectable via P-Spectrum Rate and P-VScope zone options"
      Top             =   6000
      Visible         =   0   'False
      Width           =   6015
   End
   Begin VB.CommandButton Demo 
      BackColor       =   &H0000FFFF&
      Caption         =   "Demo"
      Height          =   225
      Left            =   6360
      Style           =   1  'Graphical
      TabIndex        =   65
      ToolTipText     =   "Click to enter Analysis Demo screen"
      Top             =   1120
      Width           =   615
   End
   Begin VB.OptionButton Option1 
      Caption         =   "Slow"
      Height          =   255
      Index           =   4
      Left            =   8280
      TabIndex        =   64
      ToolTipText     =   "Sets Fosc= 1  "
      Top             =   3600
      Visible         =   0   'False
      Width           =   660
   End
   Begin VB.OptionButton Option1 
      Caption         =   "Normal"
      Height          =   255
      Index           =   3
      Left            =   8280
      TabIndex        =   63
      ToolTipText     =   "Sets Fosc = 0 "
      Top             =   3360
      Visible         =   0   'False
      Width           =   855
   End
   Begin VB.TextBox Text2 
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   0  'None
      Height          =   255
      Index           =   2
      Left            =   120
      Locked          =   -1  'True
      TabIndex        =   37
      Text            =   $"SpectrumMain.frx":04DE
      ToolTipText     =   "There are five scale markings, each selectable via P-Spectrum Rate and P-VScope zone options"
      Top             =   5760
      Visible         =   0   'False
      Width           =   6015
   End
   Begin VB.TextBox Text2 
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   0  'None
      Height          =   255
      Index           =   1
      Left            =   120
      Locked          =   -1  'True
      TabIndex        =   36
      Text            =   $"SpectrumMain.frx":057F
      ToolTipText     =   "There are five scale markings, each selectable via P-Spectrum Rate and P-VScope zone options"
      Top             =   5760
      Visible         =   0   'False
      Width           =   6015
   End
   Begin VB.TextBox Text2 
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   0  'None
      Height          =   255
      Index           =   0
      Left            =   120
      Locked          =   -1  'True
      TabIndex        =   35
      Text            =   $"SpectrumMain.frx":061F
      ToolTipText     =   "There are five scale markings, each selectable via P-Spectrum Rate and P-VScope zone options"
      Top             =   5760
      Visible         =   0   'False
      Width           =   6015
   End
   Begin VB.Frame Frame1 
      BorderStyle     =   0  'None
      Height          =   1100
      Left            =   6360
      TabIndex        =   53
      Top             =   4360
      Width           =   375
      Begin VB.OptionButton Option2 
         Height          =   255
         Index           =   2
         Left            =   0
         TabIndex        =   56
         ToolTipText     =   "Activates named file shown on this line"
         Top             =   80
         Width           =   330
      End
      Begin VB.OptionButton Option2 
         Height          =   195
         Index           =   3
         Left            =   0
         TabIndex        =   57
         ToolTipText     =   "Activates named file shown on this line"
         Top             =   840
         Width           =   330
      End
      Begin VB.OptionButton Option2 
         Height          =   255
         Index           =   1
         Left            =   0
         TabIndex        =   55
         ToolTipText     =   "Activates named file shown on this line"
         Top             =   570
         Width           =   330
      End
      Begin VB.OptionButton Option2 
         Height          =   255
         Index           =   0
         Left            =   0
         TabIndex        =   54
         ToolTipText     =   "Activates named file shown on this line"
         Top             =   330
         Width           =   330
      End
   End
   Begin VB.CommandButton PSDirectory 
      BackColor       =   &H0000FF00&
      Caption         =   "All"
      Height          =   255
      Index           =   3
      Left            =   6720
      Style           =   1  'Graphical
      TabIndex        =   47
      ToolTipText     =   "Accesses directory for all disk files"
      Top             =   5160
      Width           =   495
   End
   Begin VB.CommandButton PSDirectory 
      BackColor       =   &H0000FF00&
      Caption         =   "SJM"
      Height          =   255
      Index           =   1
      Left            =   6720
      Style           =   1  'Graphical
      TabIndex        =   44
      ToolTipText     =   "Accesses directory for Vscope simulation disk files with extension SJM"
      Top             =   4920
      Width           =   495
   End
   Begin VB.TextBox Text2 
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   0  'None
      Height          =   255
      Index           =   4
      Left            =   120
      Locked          =   -1  'True
      TabIndex        =   43
      Text            =   $"SpectrumMain.frx":06BE
      ToolTipText     =   "There are five scale markings, each selectable via P-Spectrum Rate and P-VScope zone options"
      Top             =   5760
      Visible         =   0   'False
      Width           =   6015
   End
   Begin VB.TextBox Text1 
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   0  'None
      Height          =   285
      Index           =   3
      Left            =   120
      Locked          =   -1  'True
      TabIndex        =   40
      Text            =   $"SpectrumMain.frx":075F
      ToolTipText     =   "There are five scale markings, each selectable via P-Spectrum Rate and P-VScope zone options"
      Top             =   6000
      Visible         =   0   'False
      Width           =   6015
   End
   Begin VB.CommandButton Command2 
      BackColor       =   &H00FFFF00&
      Caption         =   "Edit Scales"
      Height          =   225
      Left            =   8880
      Style           =   1  'Graphical
      TabIndex        =   39
      ToolTipText     =   "Allows scale markings to be customised and then saved to disk"
      Top             =   1120
      Width           =   975
   End
   Begin VB.CommandButton Command1 
      BackColor       =   &H0000FFFF&
      Caption         =   "Save Scales"
      Height          =   495
      Left            =   2880
      Style           =   1  'Graphical
      TabIndex        =   38
      ToolTipText     =   "Causes customised scale marking to be save to disk for recall when program is re-run"
      Top             =   4800
      Visible         =   0   'False
      Width           =   615
   End
   Begin VB.TextBox Text1 
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   0  'None
      Height          =   285
      Index           =   2
      Left            =   120
      Locked          =   -1  'True
      TabIndex        =   34
      Text            =   $"SpectrumMain.frx":07EC
      ToolTipText     =   "There are five scale markings, each selectable via P-Spectrum Rate and P-VScope zone options"
      Top             =   6000
      Visible         =   0   'False
      Width           =   6015
   End
   Begin VB.TextBox Text1 
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   0  'None
      Height          =   285
      Index           =   1
      Left            =   120
      Locked          =   -1  'True
      TabIndex        =   33
      Text            =   $"SpectrumMain.frx":088C
      ToolTipText     =   "There are five scale markings, each selectable via P-Spectrum Rate and P-VScope zone options"
      Top             =   6000
      Visible         =   0   'False
      Width           =   6015
   End
   Begin VB.TextBox Text1 
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   0  'None
      Height          =   285
      Index           =   0
      Left            =   120
      Locked          =   -1  'True
      TabIndex        =   32
      Text            =   $"SpectrumMain.frx":0922
      ToolTipText     =   "There are five scale markings, each selectable via P-Spectrum Rate and P-VScope zone options"
      Top             =   6000
      Visible         =   0   'False
      Width           =   6015
   End
   Begin VB.OptionButton Option1 
      Caption         =   "V.Slow"
      Height          =   255
      Index           =   2
      Left            =   7080
      TabIndex        =   31
      ToolTipText     =   "Sets P-Spectrum sample rate to one-hundredth"
      Top             =   3600
      Visible         =   0   'False
      Width           =   855
   End
   Begin VB.CheckBox Port 
      Caption         =   "3BCh"
      Height          =   225
      Index           =   2
      Left            =   8280
      TabIndex        =   25
      ToolTipText     =   "Sets PC's port address register to hex 03BC"
      Top             =   720
      Width           =   735
   End
   Begin VB.CheckBox Port 
      Caption         =   "278h"
      Height          =   255
      Index           =   1
      Left            =   8280
      TabIndex        =   24
      ToolTipText     =   "Sets PC's port address register to hex 0278"
      Top             =   480
      Width           =   735
   End
   Begin VB.CheckBox Port 
      Caption         =   "378h"
      Height          =   255
      Index           =   0
      Left            =   8280
      TabIndex        =   23
      ToolTipText     =   "Sets PC's port address register to hex 0378"
      Top             =   260
      Value           =   1  'Checked
      Width           =   735
   End
   Begin VB.CheckBox SyncButton 
      Caption         =   "Sync"
      Height          =   255
      Left            =   7200
      TabIndex        =   22
      ToolTipText     =   "Synchronises start position of pre-analysis waveform "
      Top             =   600
      Width           =   735
   End
   Begin MSComctlLib.ProgressBar ProgressBar1 
      Height          =   255
      Left            =   6360
      TabIndex        =   21
      ToolTipText     =   "Show progress as sections of selected disk file are processed"
      Top             =   5520
      Width           =   3495
      _ExtentX        =   6165
      _ExtentY        =   450
      _Version        =   393216
      Appearance      =   1
   End
   Begin VB.CheckBox ContinuousButton1 
      Caption         =   "Run"
      Height          =   255
      Left            =   8880
      TabIndex        =   18
      ToolTipText     =   "Turns continuous plotting of disk data on and off"
      Top             =   4160
      Width           =   615
   End
   Begin VB.CheckBox Channel 
      Caption         =   "Chan 2"
      Height          =   255
      Left            =   9000
      TabIndex        =   17
      ToolTipText     =   "Selects between Chan 1 and Chan 2"
      Top             =   3600
      Visible         =   0   'False
      Width           =   855
   End
   Begin VB.CheckBox ContinuousButton0 
      Caption         =   "Run"
      Height          =   255
      Left            =   7200
      TabIndex        =   1
      ToolTipText     =   "Turns continuous sampling and plotting of PIC unit data on and off"
      Top             =   2280
      Width           =   615
   End
   Begin VB.CheckBox Expand2 
      Caption         =   "Expand"
      Height          =   195
      Left            =   8040
      TabIndex        =   16
      ToolTipText     =   $"SpectrumMain.frx":09BC
      Top             =   1380
      Width           =   855
   End
   Begin VB.CheckBox BarGraphOn 
      Caption         =   "Bargraph"
      Height          =   195
      Left            =   8880
      TabIndex        =   15
      ToolTipText     =   "Switches between continuous line drawing between sample values, or showing each sample value as a vertical line"
      Top             =   1380
      Width           =   975
   End
   Begin VB.CheckBox OverlayIt 
      Caption         =   "Overlay"
      Height          =   195
      Left            =   7200
      TabIndex        =   13
      ToolTipText     =   "Causes each analysis plot to be superimposed on previous plots"
      Top             =   1380
      Width           =   855
   End
   Begin VB.CheckBox Expanded 
      Caption         =   "Expand"
      Height          =   255
      Left            =   6360
      TabIndex        =   12
      ToolTipText     =   "Expands plot display of pre-analysis waveform to show better detail of high-frequency waveforms. Does not affect analyis results"
      Top             =   600
      Width           =   855
   End
   Begin VB.CheckBox Amplified 
      Caption         =   "Amplify"
      Height          =   195
      Left            =   6360
      TabIndex        =   11
      ToolTipText     =   "Shows analysis as amplified display"
      Top             =   1380
      Width           =   855
   End
   Begin VB.Timer Timer1 
      Interval        =   1
      Left            =   5520
      Top             =   1800
   End
   Begin VB.CommandButton PSDirectory 
      BackColor       =   &H0000FF00&
      Caption         =   "Y??"
      Height          =   255
      Index           =   0
      Left            =   6720
      Style           =   1  'Graphical
      TabIndex        =   7
      ToolTipText     =   "Accesses directory for P-VScope and VScope disk files with extension Y followed by any other 2 characters"
      Top             =   4680
      Width           =   495
   End
   Begin VB.CommandButton SinglePlot 
      BackColor       =   &H00FFFF00&
      Caption         =   " Single  Plot  "
      Height          =   495
      Left            =   6360
      Style           =   1  'Graphical
      TabIndex        =   5
      ToolTipText     =   "Causes analysis and plotting of a single sample section from PIC unit "
      Top             =   2160
      Width           =   615
   End
   Begin VB.CommandButton SinglePlotDisk 
      BackColor       =   &H00FFFF00&
      Caption         =   "Single Plot"
      Height          =   225
      Left            =   6480
      Style           =   1  'Graphical
      TabIndex        =   4
      ToolTipText     =   "Causes analysis and plotting of a single sample section from disk file"
      Top             =   4140
      Width           =   975
   End
   Begin VB.CommandButton PSDirectory 
      BackColor       =   &H0000FF00&
      Caption         =   "ESA"
      Height          =   255
      Index           =   2
      Left            =   6720
      Style           =   1  'Graphical
      TabIndex        =   45
      ToolTipText     =   "Accesses directory for Spectrum disk files with extension ESA"
      Top             =   4440
      Width           =   495
   End
   Begin VB.TextBox Text2 
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   0  'None
      Height          =   255
      Index           =   3
      Left            =   120
      Locked          =   -1  'True
      TabIndex        =   42
      Text            =   $"SpectrumMain.frx":0A4C
      ToolTipText     =   "There are five scale markings, each selectable via P-Spectrum Rate and P-VScope zone options"
      Top             =   5760
      Visible         =   0   'False
      Width           =   6015
   End
   Begin VB.OptionButton Option1 
      Caption         =   "Slow"
      Height          =   255
      Index           =   0
      Left            =   6360
      TabIndex        =   29
      ToolTipText     =   "Sets P-Spectrum sample rate to one-tenth"
      Top             =   3600
      Visible         =   0   'False
      Width           =   735
   End
   Begin VB.OptionButton Option1 
      Caption         =   "Normal"
      Height          =   255
      Index           =   1
      Left            =   6360
      TabIndex        =   30
      ToolTipText     =   "Fastest P-Spectrum sample rate"
      Top             =   3360
      Visible         =   0   'False
      Width           =   855
   End
   Begin VB.CheckBox SaveIt 
      Caption         =   "Save Next Batch"
      Height          =   195
      Left            =   6360
      TabIndex        =   46
      ToolTipText     =   "Causes next PIC sample to be saved to disk with coded Date/Time name plus extension ESA "
      Top             =   2760
      Width           =   1575
   End
   Begin VB.Label SpecialNote 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Caption         =   "Special Note"
      Height          =   225
      Left            =   3840
      TabIndex        =   70
      ToolTipText     =   "Click here to read an important caution!"
      Top             =   0
      Width           =   975
   End
   Begin VB.Label Saved 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Caption         =   "Saved"
      Height          =   195
      Left            =   6360
      TabIndex        =   69
      Top             =   2760
      Visible         =   0   'False
      Width           =   1575
   End
   Begin VB.Label Label7 
      Caption         =   "Label7"
      Height          =   135
      Left            =   6840
      TabIndex        =   68
      Top             =   2760
      Width           =   135
   End
   Begin VB.Label Label8 
      Alignment       =   2  'Center
      BackColor       =   &H00C0C0C0&
      Caption         =   " Not Selected"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   255
      Left            =   8280
      TabIndex        =   67
      ToolTipText     =   "Click on this label to activate P-VScope controls"
      Top             =   3480
      Visible         =   0   'False
      Width           =   1575
   End
   Begin VB.Label Label5 
      Alignment       =   2  'Center
      Caption         =   " Not Selected"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   255
      Left            =   6360
      TabIndex        =   66
      ToolTipText     =   "Click on this label to activate P-Spectrum controls"
      Top             =   3480
      Visible         =   0   'False
      Width           =   1575
   End
   Begin VB.Shape Shape11 
      BorderColor     =   &H00800000&
      BorderWidth     =   2
      Height          =   720
      Left            =   90
      Shape           =   4  'Rounded Rectangle
      Top             =   5655
      Width           =   6085
   End
   Begin VB.Shape Shape1 
      BackColor       =   &H00800000&
      BackStyle       =   1  'Opaque
      FillColor       =   &H00C0C0C0&
      Height          =   3765
      Left            =   120
      Top             =   1920
      Width           =   6030
   End
   Begin VB.Label Label4 
      Alignment       =   2  'Center
      BackColor       =   &H00FFFF00&
      Caption         =   "Hover mouse cursor over buttons/labels for functional description"
      ForeColor       =   &H00000000&
      Height          =   225
      Left            =   5280
      TabIndex        =   62
      ToolTipText     =   "It does what it says on the label! But click here for an additional note."
      Top             =   0
      Width           =   4695
   End
   Begin VB.Label Bytes 
      Alignment       =   1  'Right Justify
      Caption         =   "0"
      Height          =   255
      Index           =   3
      Left            =   9360
      TabIndex        =   61
      ToolTipText     =   "Number of bytes in selected file"
      Top             =   5160
      Width           =   495
   End
   Begin VB.Label Bytes 
      Alignment       =   1  'Right Justify
      Caption         =   "0"
      Height          =   255
      Index           =   2
      Left            =   9360
      TabIndex        =   60
      ToolTipText     =   "Number of bytes in selected file"
      Top             =   4440
      Width           =   495
   End
   Begin VB.Label Bytes 
      Alignment       =   1  'Right Justify
      Caption         =   "0"
      Height          =   255
      Index           =   1
      Left            =   9360
      TabIndex        =   59
      ToolTipText     =   "Number of bytes in selected file"
      Top             =   4920
      Width           =   495
   End
   Begin VB.Label Bytes 
      Alignment       =   1  'Right Justify
      Caption         =   "0"
      Height          =   255
      Index           =   0
      Left            =   9360
      TabIndex        =   58
      ToolTipText     =   "Number of bytes in selected file"
      Top             =   4680
      Width           =   495
   End
   Begin VB.Label Named 
      Height          =   255
      Index           =   3
      Left            =   7320
      TabIndex        =   52
      ToolTipText     =   "Double-click on file name for full path details"
      Top             =   5160
      Width           =   2415
   End
   Begin VB.Label Named 
      Height          =   255
      Index           =   2
      Left            =   7320
      TabIndex        =   51
      ToolTipText     =   "Double-click on file name for full path details"
      Top             =   4440
      Width           =   2415
   End
   Begin VB.Label Named 
      Height          =   255
      Index           =   1
      Left            =   7320
      TabIndex        =   50
      ToolTipText     =   "Double-click on file name for full path details"
      Top             =   4920
      Width           =   2415
   End
   Begin VB.Label Named 
      Height          =   255
      Index           =   0
      Left            =   7320
      TabIndex        =   49
      ToolTipText     =   "Double-click on file name for full path details"
      Top             =   4680
      Width           =   2415
   End
   Begin VB.Label FileClass 
      Height          =   375
      Left            =   6360
      TabIndex        =   48
      ToolTipText     =   "Shows details of selected disk file origin and date/time of recording"
      Top             =   5880
      Width           =   3495
   End
   Begin VB.Label Label12 
      Alignment       =   2  'Center
      Caption         =   "EPE PIC SPECTRUM ANALYSER"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   735
      Left            =   8400
      TabIndex        =   28
      ToolTipText     =   $"SpectrumMain.frx":0AEC
      Top             =   1845
      Width           =   1335
   End
   Begin VB.Shape Shape10 
      BorderColor     =   &H00800000&
      BorderWidth     =   2
      Height          =   1215
      Left            =   8160
      Shape           =   4  'Rounded Rectangle
      Top             =   1800
      Width           =   1815
   End
   Begin VB.Label Label6 
      Alignment       =   2  'Center
      Caption         =   "PIC Path"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00800000&
      Height          =   255
      Left            =   6840
      TabIndex        =   27
      ToolTipText     =   "Zone for selecting way in which PIC-sampled data is acquired"
      Top             =   1845
      Width           =   975
   End
   Begin VB.Shape Shape9 
      BorderColor     =   &H00800000&
      BorderWidth     =   2
      Height          =   855
      Left            =   8160
      Shape           =   4  'Rounded Rectangle
      Top             =   3120
      Width           =   1815
   End
   Begin VB.Label Label11 
      Caption         =   "System"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00800000&
      Height          =   225
      Left            =   9000
      TabIndex        =   26
      ToolTipText     =   "Zone which allows PC's correct printer port register address plus Hard Drive to be selected"
      Top             =   270
      Width           =   735
   End
   Begin VB.Shape Shape8 
      BorderColor     =   &H00800000&
      BorderWidth     =   2
      Height          =   735
      Left            =   8160
      Shape           =   4  'Rounded Rectangle
      Top             =   240
      Width           =   1815
   End
   Begin VB.Label Active1 
      Alignment       =   2  'Center
      Caption         =   "Disk Mode"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00008000&
      Height          =   225
      Left            =   8520
      TabIndex        =   20
      ToolTipText     =   "Shows whether PIC or Disk is data source currently in use "
      Top             =   2640
      Visible         =   0   'False
      Width           =   1140
   End
   Begin VB.Label Active0 
      Alignment       =   2  'Center
      Caption         =   "PIC Mode"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00008000&
      Height          =   255
      Left            =   8520
      TabIndex        =   19
      ToolTipText     =   "Shows whether PIC or Disk is data source currently in use "
      Top             =   2640
      Width           =   1155
   End
   Begin VB.Label SpectrumUnit 
      Alignment       =   2  'Center
      Caption         =   " P-Spectrum"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00800000&
      Height          =   255
      Left            =   6360
      TabIndex        =   14
      ToolTipText     =   "Click on this label to activate P-Spectrum controls"
      Top             =   3165
      Width           =   1575
   End
   Begin VB.Shape Shape7 
      BorderColor     =   &H00800000&
      BorderWidth     =   2
      Height          =   1215
      Left            =   6240
      Shape           =   4  'Rounded Rectangle
      Top             =   1800
      Width           =   1815
   End
   Begin VB.Label Label3 
      Alignment       =   2  'Center
      Caption         =   "Analysis Display"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00800000&
      Height          =   270
      Left            =   6960
      TabIndex        =   10
      ToolTipText     =   "Zone which controls the way analysis data is displayed"
      Top             =   1125
      Width           =   1935
   End
   Begin VB.Shape Shape6 
      BorderColor     =   &H00800000&
      BorderWidth     =   2
      Height          =   615
      Left            =   6240
      Shape           =   4  'Rounded Rectangle
      Top             =   1080
      Width           =   3735
   End
   Begin VB.Shape Shape5 
      BorderColor     =   &H00800000&
      BorderWidth     =   2
      Height          =   735
      Left            =   6240
      Shape           =   4  'Rounded Rectangle
      Top             =   240
      Width           =   1815
   End
   Begin VB.Label Label2 
      Alignment       =   2  'Center
      Caption         =   "Input Display"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00800000&
      Height          =   255
      Left            =   6360
      TabIndex        =   9
      ToolTipText     =   "Zone which controls the way pre-analysis waveform data is displayed"
      Top             =   240
      Width           =   1575
   End
   Begin VB.Label Label1 
      Alignment       =   2  'Center
      Caption         =   " Disk Path"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00800000&
      Height          =   255
      Left            =   7560
      TabIndex        =   8
      ToolTipText     =   "Zone for selecting analysis of pre-recorded waveform files"
      Top             =   4140
      Width           =   1215
   End
   Begin VB.Shape Shape4 
      BorderColor     =   &H00800000&
      BorderWidth     =   2
      Height          =   2295
      Left            =   6240
      Shape           =   4  'Rounded Rectangle
      Top             =   4080
      Width           =   3735
   End
   Begin VB.Shape Shape3 
      BackColor       =   &H00FFFFFF&
      BorderColor     =   &H00800000&
      BorderWidth     =   2
      Height          =   855
      Left            =   6240
      Shape           =   4  'Rounded Rectangle
      Top             =   3120
      Width           =   1815
   End
   Begin VB.Label VScopeUnit 
      Alignment       =   2  'Center
      Caption         =   " P-VScope"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00800000&
      Height          =   255
      Left            =   8520
      TabIndex        =   6
      ToolTipText     =   "Click on this label to activate P-VScope controls"
      Top             =   3165
      Width           =   1335
   End
   Begin VB.Shape Shape2 
      BackColor       =   &H00800000&
      BackStyle       =   1  'Opaque
      Height          =   1575
      Left            =   120
      Top             =   240
      Width           =   6015
   End
   Begin VB.Label TimeLabel 
      Caption         =   "Time"
      Height          =   225
      Left            =   2640
      TabIndex        =   3
      ToolTipText     =   "Displays date/time at which last analysis was plotted"
      Top             =   0
      Width           =   855
   End
   Begin VB.Label DateLabel 
      Caption         =   "Date"
      Height          =   225
      Left            =   1680
      TabIndex        =   2
      ToolTipText     =   "Displays date/time at which last analysis was plotted"
      Top             =   0
      Width           =   855
   End
   Begin VB.Label DateTime 
      Alignment       =   2  'Center
      Caption         =   "Display Date/Time"
      Height          =   225
      Left            =   120
      TabIndex        =   0
      ToolTipText     =   "Displays date/time at which last analysis was plotted"
      Top             =   0
      Width           =   1335
   End
End
Attribute VB_Name = "SpectrumMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'EPE PIC Spectrum Analyser: COPYRIGHT (c) JOHN BECKER V1.0 10NOV01

Public Sub Form_Load()
On Error GoTo showerror
LoadIt = 1: 'flag to indicate prog is in its loading stage
PowerFault = 1: 'flag to ensure PIC unit is configured
DemoReady = 0: 'flag to indicate if there's data to demonstrate
PicDelay = 100000: 'time-out delay max before PIC handshake taken as not received
OpenFile = "An unknown problem exists right at the start of loading SpectrumMainProgram."
On Error GoTo showerror: 'set error handler

newuser = 0:
ErrorMessage$ = "This error has been intercepted by the PC System, not by Spectrum. "
ErrorMessage$ = ErrorMessage$ & "If the problem persists please report its details and circumstances of it occurring to John Becker at EPE"
defaulterror$ = ErrorMessage$

On Error GoTo showerror1: 'set error handler used to check if prog has been run before
Open "SpectrumClear.txt" For Input As #1: Close: FileCounter = 0:

On Error GoTo showerror: 'set error handler

Port1 = 888: Port2 = 889: Port3 = 890: DefaultDrive = "C:\"
OpenFile = "File SpectrumSettings.txt cannot be found, or its data is corrupted"
Open "SpectrumSettings.txt" For Input As #1
Line Input #1, tempA$: Port1 = Val(tempA$): Port2 = Port1 + 1: Port3 = Port1 + 2

Line Input #1, tempA$: PicUnit = Val(tempA$)
Line Input #1, tempA$: DriveC$ = tempA$
Line Input #1, tempA$: SpectrumDir.Combo1.Text = tempA$
Close
DefaultDrive = DriveC$
Drive1 = DriveC$

For A = 0 To 3: tempA$ = "No File Selected Yet": Named(A).Caption = tempA$
InputFile(A) = tempA$: NamedFile(A) = tempA$: InputSize(A) = 0: Next

OpenFile = "INPOUT32.DLL not found"

Out Port1, 0
If UCase$(Left$(DriveC$, 3)) <> DefaultDrive Then DriveC$ = DefaultDrive

OpenFile = "Cannot correctly access Spectrum Directory Default Drive path  " & DefaultDrive

SpectrumDir.Drive1.Drive = DefaultDrive
OpenFile = "Cannot correctly access Spectrum Directory (Drive C$) path  " & DriveC$
SpectrumDir.Dir1.Path = DriveC$

HistoryQ = 0:
If newuser = 0 Then
OpenFile = "Cannot find SpectrumHistory.txt file, or its data is corrupted"
Open "SpectrumHistory.txt" For Input As #1
getit: If EOF(1) = 0 Then
Line Input #1, tempA$
 If tempA$ <> "" And tempA$ <> History(HistoryQ) Then
 HistoryQ = HistoryQ + 1: History(HistoryQ) = tempA$
 SpectrumDir.Combo1.AddItem tempA$
 End If
GoTo getit
Else
Close 1
End If
Else: tempA$ = DriveC$
Open "SpectrumHistory.txt" For Output As #2: Print #2, "C:\": Close 2
End If
'SpectrumDir.Combo1.Text = tempA$

OpenFile = "Cannot find SpectrumTable.txt file, or its data is corrupted"

Open "SpectrumTable.txt" For Input As #1
For A = 1 To 1024: Line Input #1, tempA$: Table(A) = Val(tempA$)
Samples(A) = 0: Next: Close 1

OpenFile = "Problem at Welcome Message!"

If newuser = 1 Then
SpectrumMain.Visible = True
SpectrumMain.Refresh
 Beep
 tempA$ = "WELCOME!" & Chr(13) & Chr(13)
 tempA$ = tempA$ & "EPE Spectrum Analyser (ESA) has now been loaded and it detects that this is the first time that you have run it on this computer."
 tempA$ = tempA$ & Chr(13) & Chr(13)
 tempA$ = tempA$ & "If you cannot see all the Spectrum screen, your display may be set"
 tempA$ = tempA$ & " to 640 x 480 pixels. For optimum viewing, set it to"
 tempA$ = tempA$ & " 800 x 600 pixels through the PC's My Computer/Control Panel/Display/Settings option."
 tempA$ = tempA$ & Chr(13) & Chr(13)
 tempA$ = tempA$ & "Note that even if your screen cannot be set to the ideal area, you still have access to all the control buttons, even though you may not see some of the display."
 tempA$ = tempA$ & " The full-screen illustration in EPE will show that you are not missing essential information."
 tempA$ = tempA$ & Chr(13) & Chr(13)
 tempA$ = tempA$ & "For all other information read the EPE Spectrum Analyser text published in EPE xxx 2002."
 tempA$ = tempA$ & " This message will not be shown again."
 MsgBox tempA$, vbInformation
 newsuser = 0
 End If

'...............

OpenFile = "Problem during setting maths factors"
StartSpectrum:

HandShake = 248: PicChan = 10: Mode = 0: Trace = 1
Sample% = 1: SampleRate = 0

PI = 3.141592653589 / 180: TWOPI = 6.283185
PicPath = 0: PrevPicPath = 4: SelectedFilePath = 4
AA$ = "JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC": C = 1
For A = 1 To 36 Step 3: month$(C) = Mid$(AA$, A, 3): C = C + 1: Next

Box1Top = 2040: Box1Height = Shape1.Height - 300: Box2Top = 240: Box2height = 1575
Boxleft = 120: BoxWidth = 6015

PlotLength = 1024: Rem number of samples - must be a "power of 2" value
DisplayLength = PlotLength \ 2 - 4:
None = PlotLength - 1: Rem number of samples less one
Depth = CInt(Log(PlotLength) / Log(2)): Rem the depth of decomposition of the transform:Rem (log to the base 2 of the sample PlotLength)
Hres = (BoxWidth * 2) / PlotLength: Rem horizontal pixels per displayed point
Vres = Box1Height: Rem useful vertical pixels
Ascale = (Amplified.Value + 1) And 1: Rem 1 for autoscaling, 0 for clipping

Rem fill trigonometric arrays
For N = 0 To None
  Cosines(N) = Cos(TWOPI * N / PlotLength):  Sines(N) = Sin(TWOPI * N / PlotLength)
  Next

DateLabel.Caption = Date$: TimeLabel.Caption = Time$

OpenFile = "SpectrumScales.TXT"
Open "SpectrumScales.TXT" For Input As #1
For A = 0 To 4
Input #1, tempA$: tempA$ = Mid$(tempA$, 2): Text1(A).Text = tempA$: Next
For A = 0 To 4
Input #1, tempA$: tempA$ = Mid$(tempA$, 2): Text2(A).Text = tempA$: Next
Close: OpenFile = "Problem after last file data input during setting-up"

If PicUnit = 0 Then Label5.Visible = True: Label8.Visible = True
If PicUnit = 1 Then Call SpectrumUnit_Click
If PicUnit = 2 Then Call VScopeUnit_Click

OpenFile = "Problem with setting SpectrumDir.Drive1.Drive"
SpectrumDir.Drive1.Drive = DefaultDrive
OpenFile = "Problem with setting SpectrumDir.Dir1.Path"
SpectrumDir.Dir1.Path = SpectrumDir.Combo1.Text
LoadIt = 0
OpenFile = "Problem after end of setting-up"
Exit Sub

showerror1:
Open "SpectrumClear.txt" For Output As #2
Print #2, "Spectrum first loaded " & Date$ & " " & Time$: Close
DriveC$ = "C:\": newuser = 1: Close
Resume Next

showerror2:
Close
                       
SpectrumShowError.Show
Call SpectrumShowError.waitresponse
Resume enderror
enderror:
Exit Sub

showerror:
Beep
tempB$ = "A non-recoverable error has occurred during program loading and involves the following Spectrum-generated statement:"
tempB$ = tempB$ & Chr(13) & Chr(13) & OpenFile
tempB$ = tempB$ & Chr(13) & Chr(13) & "Please check that all the Spectrum files are in the same folder (directory) as the program you are now trying to run. The folder must be on the Hard Drive."
tempB$ = tempB$ & Chr(13) & Chr(13) & "If the data is corrupted re-copy the file of the same name from your original disk or FTP download."
tempB$ = tempB$ & Chr(13) & Chr(13) & "If you cannot resolve the problem please advise John Becker of the details via the EPE Editorial Office (not via the Chat Zone)."
tempB$ = tempB$ & Chr(13) & Chr(13) & "The loading has been aborted and you will be returned to the previous screen."
MsgBox tempB$, vbCritical
End

End Sub

Public Sub SaveDefaults()
Close: FileCounter = 0: Open "SpectrumSettings.txt" For Output As #2
If Len(DriveC$) <> 3 Then DriveC$ = "C:\"
Print #2, Str$(Port1): Print #2, PicUnit: Print #2, DriveC$:
Print #2, SpectrumDir.Combo1.Text: ' Call dirshow
Close
End Sub

Private Sub Default()
If Mode = 1 Then Call RestoreScale

Out Port1, 8: For A = 1 To 10000: Next
Out Port1, 0: For A = 1 To 10000: Next

Out Port1, 8: t = Timer + 1
waitreset:
If Timer > t Then tempA$ = "No PIC response Default Pt0 reset": GoTo Problem
B = Inp(Port2) Or 128: If (B And 248) <> 248 Then GoTo waitreset
Out Port1, 0


Out Port1, PicChan: t = Timer + 1
chandef:
If Timer > t Then tempA$ = "No PIC response Default Pt1 reset": GoTo Problem
If (Inp(Port2) And 248) <> HandShake Then GoTo chandef

Out Port1, 0: t = Timer + 1
waitzerodef:
If Timer > t Then tempA$ = "No PIC response during Default Pt2 reset": GoTo Problem
If (Inp(Port2) And 248) = HandShake Then GoTo waitzerodef

PicMem = 13 + Sample%: Out Port1, PicMem: t = Timer + 1
waitmemdef:
If Timer > t Then tempA$ = "No PIC response during Default Pt3 reset": GoTo Problem
If (Inp(Port2) And 248) <> HandShake Then GoTo waitmemdef

Out Port1, 0: t = Timer + 1
waitzerodef2:
If Timer > t Then tempA$ = "No PIC response during Default Pt4 reset": GoTo Problem
If (Inp(Port2) And 248) = HandShake Then GoTo waitzerodef2

AdcRate: Out Port1, 9: t = Timer + 1
waitadc:
If Timer > t Then tempA$ = "No PIC response during Default Pt5 reset": GoTo Problem
If (Inp(Port2) And 248 And 240) <> (HandShake And 240) Then GoTo waitadc

fosc = (Inp(Port2) / 8 + 1) And 1: Out Port1, 0: t = Timer + 1
waitzeroadc:
If Timer > t Then tempA$ = "No PIC response during Default Pt6 reset": GoTo Problem
If (Inp(Port2) And 248 And 240) = (HandShake And 240) Then GoTo waitzeroadc
If fosc <> SampleRate Then GoTo AdcRate
PowerFault = 0: DemoReady = 1
Exit Sub

Problem: Beep
tempA$ = tempA$ & Chr(13) & Chr(13) & "Check your power and cable connections, plus Port address, and then continue"
MsgBox tempA$, vbExclamation: ContinuousButton0.Value = 0: PowerFault = 1
End Sub

Private Sub Label4_Click()
AA$ = "Visual Basic 6 (in which this program is written) does not seem to cause the yellowish 'Tool Tip Text' notes to cancel themselves when"
AA$ = AA$ & " the mouse cursor remains over them, unlike in some other software. You must shift the"
AA$ = AA$ & " cursor away for them to become hidden again."
MsgBox AA$, vbInformation
End Sub

Private Sub SpecialNote_Click()
AA$ = "Beware when sampling higher frequency waveforms that you do not sample at 'Sub-Harmonic' rates,"
AA$ = AA$ & " which will give erroneous results. For example, sampling a 20kHz waveform at the Spectrum"
AA$ = AA$ & " 'V.Slow' rate could be interpreted as it having a frequency of only about 3kHz."
MsgBox AA$, vbExclamation
End Sub

Private Sub SpectrumUnit_Click()
Sample% = 1: PicChan = 10
Label5.Visible = False: Label5.Refresh: Label8.Visible = True
Option1(3).Visible = False: Option1(4).Visible = False: Channel.Visible = False
Option1(0).Visible = True: Option1(1).Visible = True: Option1(2).Visible = True
Option1(0).Refresh: Option1(1).Refresh: Option1(2).Refresh
Option1(1).Value = True: PicUnit = 1: Call SaveDefaults
End Sub

Private Sub Label5_Click()
Call SpectrumUnit_Click
End Sub

Private Sub VScopeUnit_Click()
Sample% = 1: PicChan = 10
Label5.Visible = True: Label8.Visible = False
Option1(3).Visible = True: Option1(4).Visible = True: Channel.Visible = True
Option1(3).Refresh: Option1(4).Refresh: Channel.Refresh
Option1(0).Visible = False: Option1(1).Visible = False: Option1(2).Visible = False
Option1(3).Value = True: PicUnit = 2: Call SaveDefaults
End Sub

Private Sub Label8_Click()
Call VScopeUnit_Click
End Sub

Private Sub Named_dblClick(Index As Integer)
Beep
MsgBox "Full path name =" & Chr(13) & Chr(13) & InputFile(Index) & "    ", vbInformation
End Sub

Private Sub Option2_Click(Index As Integer)
If Option2(Index).Value = False Then Exit Sub
On Error GoTo showerror

filecheck:
OpenFile = NamedFile(Index)
If InputSize(Index) = 0 Then
  Beep
  tempA$ = "No file for this path selected"
  tempA$ = tempA$ & Chr(13) & "Choose another option"
  FileClass.Caption = "": ProgressBar1.Value = 1: FileCounter = 0
  MsgBox tempA$, vbInformation
  ContinuousButton1.Value = 0: SelectedFilePath = 4
  Option2(Index).Value = 0
  Call showinput: Call Analysis
  Exit Sub
  End If

Close: FileCounter = 0:
Open InputFile(Index) For Input As #1: CC$ = Input$(15, 1): Close: 'file error check

SelectedFilePath = Index: PicPath = Index:
ContinuousButton1.Value = 1: Mode = 1: Close:  FileCounter = 0
AA$ = NamedFile(PicPath)
tempA$ = "Source unknown - Frequency Scale Not Quantifyable"
   For A = 0 To 4: SpectrumMain.Text1(A).Visible = False: SpectrumMain.Text2(A).Visible = False: Next
   
BB$ = Right$(AA$, 3)
If Left$(BB$, 1) = "Y" And Len(AA$) = 12 Then
    A = Asc(Mid$(AA$, 3, 1)) - 48: If A > 8 Then A = A - 7: 'month
    BB$ = Left$(AA$, 2) & month$(A) & Right$(AA$, 2)
    A = Asc(Mid$(AA$, 4, 1)) - 48: If A > 8 Then A = A - 7
    BB$ = BB$ & Str$(A) & ":" & Mid$(AA$, 5, 2) & "." & Mid$(AA$, 7, 2)
   tempA$ = "Source = V-Scope or P-VScope " & BB$ & "   Frequency Scale Not Quantifyable"
   End If

If Right$(AA$, 3) = "SJM" Then
   tempA$ = "Source = V-Scope Simulation - Frequency Scale Not Quantifyable"
      For A = 0 To 4: SpectrumMain.Text1(A).Visible = False: SpectrumMain.Text2(A).Visible = False: Next
   End If
If Right$(AA$, 3) = "ESA" Then
   A = Val(Left$(AA$, 2)): If A > 12 Or A = 0 Then GoTo bypass
   'tempA$ = "Source = P-Spectrum  " & Mid$(AA$, 3, 2) & month$(A) & Mid$(AA$, 5, 4)
   tempA$ = Mid$(AA$, 3, 2) & month$(A) & Mid$(AA$, 5, 4)
   tempA$ = tempA$ & " " & Mid$(AA$, 9, 2) & ":" & Mid$(AA$, 11, 2) & ":" & Mid$(AA$, 13, 2)
For A = 0 To 4: SpectrumMain.Text1(A).Visible = False: SpectrumMain.Text2(A).Visible = False: Next
   
   BB$ = Mid$(CC$, 9, 6): B = 0:
   CC$ = ""
   If Left$(BB$, 1) = "1" Then
   If Left$(BB$, 4) = "1001" Then CC$ = " V.Slow": B = 2
   If Left$(BB$, 4) = "1010" Then CC$ = " Normal": B = 1
   If Left$(BB$, 4) = "1100" Then CC$ = " Slow": B = 0
   tempA$ = "Source = P-Spectrum  " & tempA$
   End If
   
   If Left$(BB$, 1) = "2" Then
   If Mid$(BB$, 5, 2) = "10" Then CC$ = " Normal": B = 3
   If Mid$(BB$, 5, 2) = "01" Then CC$ = " Slow": B = 4
   tempA$ = "Source = P-VScope via P-Spectrum  " & tempA$
   End If
   
   tempA$ = tempA$ & CC$
   ScaleVal = B
   SpectrumMain.Text1(B).Visible = True: SpectrumMain.Text2(B).Visible = True
   End If

bypass:
SpectrumMain.FileClass.Caption = tempA$
Exit Sub

showerror:
Close:  FileCounter = 0
SpectrumShowError.Show
Call SpectrumShowError.waitresponse
If Err.Number = 53 Then
 If SelectedFilePath = 4 Then Option2(Index).Value = False: Resume enderror
Index = PicPath: Option2(Index).Value = True
Else
ContinuousButton1.Value = 0:
End If
Resume enderror
enderror:
Exit Sub

End Sub

Private Sub PSDirectory_Click(Index As Integer)
On Error GoTo showerror
ContinuousButton1.Value = 0: SelectedFilePath = 4: FileClass.Caption = ""
ProgressBar1.Value = 1: FileCounter = 0
For A = 0 To 3: Option2(A).Value = False: Next
Timer1.Enabled = False

PicPath = Index:
  FileName = "*.???"
Select Case Index
  Case 0: FileName = "*.Y??"
  Case 1: FileName = "*.SJM"
  Case 2: FileName = "*.ESA"
  Case 3: FileName = "*.???"
End Select

If SpectrumDir.Combo1.ListCount = 0 Then
SpectrumDir.Combo1.Clear
For A = 1 To HistoryQ: SpectrumDir.Combo1.AddItem History(A): Next
SpectrumDir.Combo1.Text = History(1)
SpectrumDir.BackColor = &HC0C0C0
End If

If SpectDir(PicPath) = "" Then SpectDir(PicPath) = DefaultDrive
OpenFile = SpectDir(PicPath)

SpectrumDir.Show
If PicPath <> PrevPicPath Then
If SpectDir(PicPath) <> DefaultDrive Then SpectrumDir.Dir1.Path = SpectDir(PicPath)
SpectrumDir.Label1.Caption = "": Call SpectrumDir.dirshow
PrevPicPath = PicPath: FilePath = InputFile(PicPath)
End If
Exit Sub

showerror:
If Err.Number = 68 Or Err.Number = 71 Or Err.Number = 76 Then
ErrorMessage = "Drive not ready for" & Chr(13) & OpenFile
Style = vbRetryCancel + vbExclamation
response = MsgBox(ErrorMessage, Style)
  If response = vbCancel Then
  SpectDir(PicPath) = DefaultDrive
  OpenFile = SpectDir(PicPath)
  Resume here
here:   Exit Sub
  End If

Resume
  Beep
  End If

SpectrumShowError.Show
Call SpectrumShowError.waitresponse
Resume enderror
enderror:
SpectrumDir.Hide
Exit Sub

enderror2:

End Sub

Public Sub Analysis(): Rem Modified from Paul Cutherbertson's MEM file "spec_an2.bas"

For N = 1 To PlotLength: Imaginary(N) = 0
Real(N) = Samples(N) * (1 - Cosines(N)) / 2: Next

TrigIndexStep = 1: JumpSize = PlotLength: Span = PlotLength / 2:

For DepthCount = 1 To Depth: TrigIndex = 0
  
  For Start = 1 To Span: Cosine = Cosines(TrigIndex): Sine = Sines(TrigIndex)
  TrigIndex = TrigIndex + TrigIndexStep
    
  For Index1 = Start To PlotLength Step JumpSize: Index2 = Index1 + Span
      RealDiff = Real(Index1) - Real(Index2)
      ImaginaryDiff = Imaginary(Index1) - Imaginary(Index2)
      Real(Index1) = Real(Index1) + Real(Index2)
      Imaginary(Index1) = Imaginary(Index1) + Imaginary(Index2)
      Real(Index2) = Cosine * RealDiff + Sine * ImaginaryDiff
      Imaginary(Index2) = Cosine * ImaginaryDiff - Sine * RealDiff
   Next: Next

  TrigIndexStep = TrigIndexStep * 2: Span = Span / 2: JumpSize = JumpSize / 2
  Next

For N = 1 To None: CalcSamples(N) = Abs(Imaginary(N)) + Abs(Real(N)): Next

Rem unscramble mirror image
Index = 1: For CountA = 1 To None
  If CountA < Index Then
  SwapReal = CalcSamples(Index)
  CalcSamples(Index) = CalcSamples(CountA)
  CalcSamples(CountA) = SwapReal
  End If

S = PlotLength / 2
While S < Index
Index = Index - S: S = S / 2
Wend
Index = Index + S
Next

Maximum = 9.999999E-39: Minimum = 1E+38:

Rem auto scaling
For N = 1 To PlotLength / 2
  If Ascale = 1 Then
  If CalcSamples(N) < Minimum Then Minimum = CalcSamples(N)
  If CalcSamples(N) > Maximum Then Maximum = CalcSamples(N)
  Else: If CalcSamples(N) > Vres Then CalcSamples(N) = Vres
  End If
  Next

If Ascale = 1 Then
Range = (Maximum - Minimum): 'Min = Minimum
Else: Range = Vres: Min = 0
End If
'Min = 0

Rem output
If Overlay = 0 Then Line (Boxleft, Box1Top)-(2 * Hres + Boxleft, Box1Top + (Box1Height + 20)), &H800000, BF
FROMY = Vres * (1 - (CalcSamples(3) - Min) / Range) + Box1Top

For N = 3 To DisplayLength
If Overlay = 0 Then
  If ExpandSpectrum = 0 Then
  Line ((N - 0) * Hres + Boxleft, Box1Top)-((N - 0) * Hres + Boxleft, Box1Top + Box1Height + 20), &H800000
  Else
  B = (N + 1) * Hres: If B > BoxWidth Then B = BoxWidth
  B = B + Boxleft
  Line ((N - 1) * Hres + Boxleft, Box1Top)-(B, Box1Top + Box1Height + 20), &H800000, BF
  End If
End If
  
TOY = Vres * (1 - (CalcSamples(N) - Min) / Range) + Box1Top
If BarGraph = 0 Then
  Line ((N - 2) * Hres + Boxleft, FROMY)-((N - 1) * Hres + Boxleft, TOY), vbWhite
  Else
  Line ((N - 2) * Hres + Boxleft, Box1Top + Box1Height)-((N - 2) * Hres + Boxleft, TOY), vbWhite
End If
FROMY = TOY: Next: Demo = 0

End Sub

Public Sub Option1_Click(Index As Integer)
For A = 0 To 4: Text1(A).Visible = False: Text2(A).Visible = False: Next
Text1(Index).Visible = True: Text2(Index).Visible = True
Mode = 0: Active0.Visible = True: Active1.Visible = False

If Index < 3 Then
Sample% = Index:
Else
SampleRate = (Index + 1) And 1
End If

If LoadIt = 0 Then
Call Default
If ContinuousButton0.Value = 0 Then Call SinglePlot_Click
End If

End Sub

Private Sub OverlayIt_Click()
Overlay = OverlayIt.Value
Call Analysis
End Sub

Public Sub PlotDisk()
On Error GoTo showerror
If InputSize(PicPath) = 0 Then
Beep

tempA$ = "No file for this path selected - choose one via the Directory buttons "
If SelectedFilePath < 4 Then tempA$ = tempA$ & Chr(13) & "The previously selected file will be continued"

MsgBox tempA$, vbInformation
Timer1.Enabled = True

If SelectedFilePath = 4 Then
Exit Sub
End If
PicPath = SelectedFilePath

End If
Mode = 1: Active1.Visible = True: Active0.Visible = False
C = 2
If PicPath <> 2 Then
If FileCounter + (PlotLength * 2) > InputSize(PicPath) Then FileCounter = 0
Else
If FileCounter + PlotLength > InputSize(PicPath) Then FileCounter = 0
End If
 
OpenFile = NamedFile(PicPath)

If FileCounter = 0 Then
Close 1
Open InputFile(PicPath) For Input As #1: Close
Open InputFile(PicPath) For Binary As #1: L = LOF(1)
ProgressBar1.Min = 1: ProgressBar1.Max = L + 20
DemoReady = 1
FileCounter = 20: tempA$ = Input$(20, 1)
End If

If PicPath = 2 Then
L = PlotLength: tempA$ = Input$(L, 1): FileCounter = FileCounter + L
ProgressBar1.Value = FileCounter
For x = 1 To L: A = Asc(Mid$(tempA$, x, 1)): C = C + 1: Samples(x) = A: Next
Else
L = PlotLength * 2: tempA$ = Input$(L, 1): FileCounter = FileCounter + L
ProgressBar1.Value = FileCounter
For x = 1 To L \ 2: A = Asc(Mid$(tempA$, C, 1)): C = C + 2: Samples(x) = A: Next
End If

Call showinput: Call Analysis: OpenFile = "": Exit Sub

showerror:
Close: ContinuousButton1.Value = 0: FileCounter = 0
SpectrumShowError.Show
Call SpectrumShowError.waitresponse
Resume enderror
enderror:
Exit Sub

End Sub

Private Sub Port_Click(Index As Integer)
If Port(0) = 0 And Port(1) = 0 And Port(2) = 0 Then Port(0) = 1: Exit Sub
If Port(Index) = 0 Then Exit Sub

If Index = 0 And Port(0) = 1 Then
PortAddress$ = "(0378h)"
  Port1 = 888: Port2 = 889: Port3 = 890
  Port(1) = 0: Port(2) = 0
End If

If Index = 1 And Port(1) = 1 Then
PortAddress$ = "(0278h)"
Port1 = 632: Port2 = 633: Port3 = 634
  Port(0) = 0: Port(2) = 0
 End If

If Index = 2 And Port(2) = 1 Then
PortAddress$ = "(03BCh)"
Port1 = 956: Port2 = 957: Port3 = 958
  Port(0) = 0: Port(1) = 0
End If

Call Default
If PowerFault = 0 Then
Call SinglePlot_Click
Beep
Call SaveDefaults
MsgBox "You've got it!" & Chr(13) & Chr(13) & "This Port value has been saved", vbExclamation
End If

End Sub

Private Sub GetPscope()
samplingloop:

Out Port1, 8: A = 0
waitreset: A = A + 1: If A > PicDelay Then GoTo Problem
B = Inp(Port2) Or 128: If (B And 248) <> 248 Then GoTo waitreset
Out Port1, 0

B = 1024: If SyncButton.Value = 1 Or SaveIt.Value = 1 Then B = 2048

For x = 1 To B: Out Port1, 0: A = 0
waital: A = A + 1: If A > PicDelay Then GoTo Problem
If (Inp(Port2) And 128) <> 0 Then GoTo waital
lsb = (Inp(Port2) \ 8) And 15

Out Port1, 1: A = 0
waital2: A = A + 1: If A > PicDelay Then GoTo Problem
If (Inp(Port2) And 128) = 0 Then GoTo waital2
msb = (Inp(Port2) * 2) And 240: Samples(x) = (msb Or lsb): Out Port1, 4: 'step PIC
For A = 1 To 1000: Next: 'brief delay

Next: Call showinput: Call Analysis

If SaveIt.Value = 1 Then
  tempA$ = Left(Date$, 2) & Mid$(Date$, 4, 2) & Right$(Date$, 4)
  tempA$ = tempA$ & Left$(Time$, 2) & Mid$(Time$, 4, 2) & Right$(Time$, 2) & ".ESA"
  Open tempA$ For Output As #2
  tempA$ = "SPECTRUM" & PicUnit: For A = 0 To 4: C = Option1(A).Value: tempA$ = tempA$ & Abs(C): Next
  tempA$ = tempA$ & "AAAAAA": 'A": 'AA"
  Print #2, tempA$;
  For x = 1 To B: Print #2, Chr(Samples(x));: Next: Print #2, "": Close: FileCounter = 0
  Beep
  SaveIt.Visible = False: Saved.Visible = True:
  Saved.Refresh:
  t = Timer + 0.8
  While Timer < t
  Wend
  SaveIt.Value = 0: Saved.Visible = False: SaveIt.Visible = True: SaveIt.Refresh
  End If
PowerFault = 0
Exit Sub

Problem:
Beep
tempA$ = "No PIC response while trying to obtain sample data"
tempA$ = tempA$ & Chr(13) & "Check your power and cable connections then try again": ' & Chr(13) & Chr(13) & "The Continuous mode has been terminated"
MsgBox tempA$, vbExclamation: ContinuousButton0.Value = 0: SaveIt.Value = 0
PowerFault = 1

End Sub

Private Sub RestoreScale()
For A = 0 To 4: Text1(A).Visible = False: Text2(A).Visible = False: Next
If PicUnit = 1 Then
For A = 0 To 2
If Option1(A).Value = True Then Text1(A).Visible = True: Text2(A).Visible = True: Exit For
Next
End If
If PicUnit = 2 Then
For A = 3 To 4
If Option1(A).Value = True Then Text1(A).Visible = True: Text2(A).Visible = True: Exit For
Next
End If
End Sub

Private Sub SampleRate_Click()
Mode = 0: Active0.Visible = True: Active1.Visible = False

ChangeOsc: Out Port1, 9: t = Timer + 1
waitadc: If Timer > t Then GoTo Problem
If (Inp(Port2) And 248 And 240) <> (HandShake And 240) Then GoTo waitadc
fosc = (Inp(Port2) / 8 + 1) And 1: Out Port1, 0: t = Timer + 1

waitzeroadc: If Timer > t Then GoTo Problem
If (Inp(Port2) And 248 And 240) = (HandShake And 240) Then GoTo waitzeroadc
If fosc <> SampleRate.Value Then GoTo ChangeOsc

For A = 0 To 4: Text1(A).Visible = False: Text2(A).Visible = False: Next
Text1(fosc + 3).Visible = True: Text2(fosc + 3).Visible = True
For A = 1 To 1000: Next
Call GetPscope: Exit Sub

Problem:
Beep
tempA$ = "No PIC response while trying to obtain to change sample rate"
tempA$ = tempA$ & Chr(13) & "Check your power and cable connections then try again": ' & Chr(13) & Chr(13) & "The Continuous mode has been terminated"
MsgBox tempA$, vbExclamation: ContinuousButton0.Value = 0: SaveIt.Value = 0
PowerFault = 1

End Sub

Private Sub SaveIt_Click()
If SaveIt.Value = 0 Then Exit Sub
If Label5.Visible = True And Label8.Visible = True Then
Beep
MsgBox "You must select a PIC unit first by clicking on its name caption", vbExclamation
SaveIt.Value = 0
Exit Sub
End If

'If Mode = 1 Then Call RestoreScale
Call RestoreScale
Mode = 0: Active0.Visible = True: Active1.Visible = False
ContinuousButton1.Value = 0: Call GetPscope
End Sub

Private Sub SinglePlot_Click()
If Label5.Visible = True And Label8.Visible = True Then
Beep
MsgBox "You must select a PIC unit first by clicking on its name caption", vbExclamation
Exit Sub
End If

'If Mode = 1 Then Call RestoreScale
Call RestoreScale
Mode = 0: Active0.Visible = True: Active1.Visible = False
ContinuousButton0.Value = 0: ContinuousButton1.Value = 0
If PowerFault = 1 Then Call Default
If PowerFault = 0 Then Call GetPscope
End Sub

Private Sub SinglePlotDisk_Click()
If SelectedFilePath <> 4 Then
For A = 0 To 4: Text1(A).Visible = False: Text2(A).Visible = False: Next
SpectrumMain.Text1(ScaleVal).Visible = True: SpectrumMain.Text2(ScaleVal).Visible = True
Mode = 1: Active1.Visible = True: Active0.Visible = False
ContinuousButton1.Value = 0: Call PlotDisk
Else
Beep
tempA$ = "No file selected yet"
tempA$ = tempA$ & Chr(13) & "Choose one via the green directory buttons"
tempA$ = tempA$ & Chr(13) & "or via the circular buttons if a named file is shown"
MsgBox tempA$, vbExclamation
Call showinput: Call Analysis
End If
End Sub

Private Sub Text1_click(Index As Integer)
If Command2.Visible = True Then Command2.SetFocus
End Sub

Private Sub Text2_click(Index As Integer)
If Command2.Visible = True Then Command2.SetFocus
End Sub

Private Sub Text3_click(Index As Integer)
If Command2.Visible = True Then Command2.SetFocus
End Sub

Private Sub Text4_click(Index As Integer)
If Command2.Visible = True Then Command2.SetFocus
End Sub

Private Sub Timer1_Timer()
If ContinuousButton0 = 1 Then
If Mode = 0 Then Call GetPscope: DateLabel.Caption = Date$: TimeLabel.Caption = Time$
End If

If ContinuousButton1 = 1 Then
If Mode = 1 Then Call PlotDisk: DateLabel.Caption = Date$: TimeLabel.Caption = Time$
End If

End Sub

Public Sub showinput()
DateLabel.Caption = Date$: TimeLabel.Caption = Time$: g = 1

If SyncButton.Value = 1 Then
For g = 1 To 1000: If Samples(g) < 127 Then Exit For
Next

For g = g To 1000: If Samples(g) >= 127 Then Exit For
Next

For g = g To 1000: If Samples(g) < 127 Then Exit For
Next
End If

If Trace = 0 Then Trace = 1
e = Trace: d = 10 * e
Line (Boxleft - 2, Box2Top)-(Boxleft + (30 * e), Box2Top + Box2height - 10), &H800000, BF
A = Samples(g) * 1.2: prevy = A * 5 + Box2Top: prevx = 1
For x = 1 To (595 / e): A = Samples(g) * 1.2: g = g + 1
C = (x + 2) * d + Boxleft: If C > (6015 + Boxleft) Then C = 6015 + Boxleft
f = C + (20 * e): If f > (6015 + Boxleft) Then f = 6015 + Boxleft
Line (C, Box2Top)-(f, Box2Top + Box2height - 10), &H800000, BF
Line (prevx * d + Boxleft, prevy)-(x * d + Boxleft, A * 5 + Box2Top), vbYellow
prevy = A * 5 + Box2Top: prevx = x: Next
End Sub

Private Sub Amplified_Click()
Ascale = (Amplified.Value + 1) And 1
Call Analysis
End Sub

Private Sub BarGraphOn_Click()
BarGraph = BarGraphOn.Value
Call Analysis
End Sub

Private Sub Channel_Click()
Mode = 0: Active0.Visible = True: Active1.Visible = False: Active1.Visible = False
If Channel.Value = 0 Then PicChan = 10 Else PicChan = 11
Call Default
Call GetPscope

End Sub

Private Sub Command1_Click()
Open "SpectrumScales.TXT" For Output As #2
For A = 0 To 4: Print #2, "." & Text1(A).Text: Text1(A).Locked = True: Text1(A).BackColor = &H8000000F: Text1(A).BorderStyle = 0: Next
For A = 0 To 4: Print #2, "." & Text2(A).Text: Text2(A).Locked = True: Text2(A).BackColor = &H8000000F: Text2(A).BorderStyle = 0: Next
Close: FileCounter = 0: Beep
Command2.Visible = True: Command1.Visible = False
MsgBox "Scales saved OK", vbExclamation
End Sub

Private Sub Command2_Click()
Command1.Visible = True: Command2.Visible = False
ContinuousButton0 = 0: ContinuousButton1 = 0
For A = 0 To 4: Text1(A).BackColor = vbWhite: Text1(A).Locked = False: Text1(A).BorderStyle = 1: Next
For A = 0 To 4: Text2(A).BackColor = vbWhite: Text2(A).Locked = False: Text2(A).BorderStyle = 1: Next
End Sub

Private Sub ContinuousButton0_Click()
If ContinuousButton0.Value = 0 Then Exit Sub
If Label5.Visible = True And Label8.Visible = True Then
Beep
MsgBox "You must select a PIC unit first by clicking on its name caption", vbExclamation
ContinuousButton0.Value = 0
Exit Sub
End If

If PowerFault = 1 Then Call Default
'If Mode = 1 Then Call RestoreScale
Call RestoreScale
If ContinuousButton0 = 1 Then
Timer1.Enabled = True: ContinuousButton1.Value = 0
Mode = 0: Active0.Visible = True: Active1.Visible = False
End If
End Sub

Private Sub ContinuousButton1_Click()
If SelectedFilePath <> 4 Then
 If ContinuousButton1 = 1 Then
For A = 0 To 4: Text1(A).Visible = False: Text2(A).Visible = False: Next
SpectrumMain.Text1(ScaleVal).Visible = True: SpectrumMain.Text2(ScaleVal).Visible = True
 ContinuousButton0.Value = 0
 Mode = 1: Active1.Visible = True: Active0.Visible = False
 End If
Else
 If ContinuousButton1.Value = 1 Then
 ContinuousButton1.Value = 0
 Beep
 tempA$ = "No file selected yet"
 tempA$ = tempA$ & Chr(13) & "Choose one via the green directory buttons"
 tempA$ = tempA$ & Chr(13) & "or via the circular buttons if a named file is shown"
 MsgBox tempA$, vbExclamation: Call showinput: Call Analysis
 End If
End If
End Sub

Private Sub Expand2_Click()
ExpandSpectrum = Expand2.Value
If ExpandSpectrum = 0 Then
Hres = (BoxWidth * 2) / PlotLength: DisplayLength = PlotLength / 2 - 4
Else
Hres = ((BoxWidth * 2) / PlotLength) * 10
DisplayLength = PlotLength / 2 - 4: DisplayLength = DisplayLength / 10
End If
Call Analysis
End Sub

Private Sub Expanded_Click()
If Expanded.Value = 0 Then Trace = 1 Else Trace = 10
Call showinput
End Sub

Private Sub Demo_Click()
If DemoReady = 0 Then
Beep
MsgBox "There's no data to demonstrate on yet, input some via PIC unit or disk option", vbExclamation
Exit Sub
End If
ContinuousButton0.Value = 0: ContinuousButton1.Value = 0
SpectrumDemo.Label12.Visible = False: SpectrumDemo.Show
Call SpectrumDemo.showinput
End Sub

Private Sub Drive1_Change()
DefaultDrive = UCase$(Drive1.Drive) & "\"
DriveC$ = DefaultDrive
SpectrumDir.Combo1.AddItem DriveC$
SpectrumDir.Dir1.Path = DriveC$
SpectrumDir.Drive1.Drive = Drive1.Drive
Call SaveDefaults
End Sub

Private Sub Label12_Click()
End
End Sub

'...................

'Extract from PIC Pscope ASM

'ROUTE:  ADDWF PCL, F
'        goto RESETP       ;0  000  PC orig val 000 = 0 (8) RESET
'        goto CHANAB       ;1  001  PC orig val 100 = 4 (12) both chans
'        goto CHANA        ;2  010  PC orig val 010 = 2 (10) chan 0
'        goto MAX2         ;3  011  PC orig val 110 = 6 (14) 2K
'        goto INCRATE      ;4  100  PC orig val 001 = 1 (9) change ADC sample rate
'        goto MAX32        ;5  101  PC orig val 101 = 5 (13) 32K
'        goto CHANB        ;6  110  PC orig val 011 = 3 (11) chan 1
'        goto MAX0         ;7  111  PC orig val 111 = 7 (15) direct
' all PC vals ORed with 8 (1000)
